<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // System Settings
        Setting::set('timezone', 'Africa/Cairo', 'string', false);
        Setting::set('max_file_size_mb', 5, 'integer', false);
        Setting::set('allowed_file_types', ['image/jpeg', 'image/jpg', 'image/png'], 'json', false);

        // Azure AD Configuration (default values - should be updated via UI)
        Setting::set('azure_ad_config', [
            'clientId' => '',
            'tenantId' => '',
            'clientSecret' => '',
            'redirectUri' => env('APP_URL') . '/api/auth/azure-ad/callback',
            'enabled' => false,
        ], 'json', true);

        // Dauha DSS Configuration (default values - should be updated via UI)
        Setting::set('dauha_dss_config', [
            'apiUrl' => '',
            'username' => '',
            'password' => '',
            'enabled' => false,
        ], 'json', true);

        // SMTP Configuration (default values - should be updated via UI)
        Setting::set('smtp_config', [
            'host' => 'smtp.gmail.com',
            'port' => 587,
            'username' => 'noreply@example.com',
            'password' => '',
            'useTLS' => true,
            'fromEmail' => 'noreply@example.com',
            'fromName' => 'Beyti Visitor Management',
        ], 'json', true);

        $this->command->info('Settings seeded successfully!');
    }
}
