<?php

namespace App\Services;

use App\Models\Visit;

class RequestIdService
{
    /**
     * Generate unique request ID in format: VIS-20250126-0001
     */
    public function generate(): string
    {
        $date = now()->format('Ymd');
        $count = Visit::whereDate('created_at', today())->count() + 1;

        return sprintf('VIS-%s-%04d', $date, $count);
    }
}
