<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Location;

class LocationController extends Controller
{
    /**
     * Get list of active locations
     */
    public function index()
    {
        $locations = Location::active()
            ->select('id', 'name', 'code')
            ->orderBy('name')
            ->get();

        return response()->json($locations);
    }
}
