# Beyti API - Apache Setup Guide (XAMPP)

## ✅ Project Location
```
F:\xampp-8.2\htdocs\beyti-api\
```

## 🌐 Access URLs

### API Base URL
```
http://localhost/beyti-api/public/api
```

### Health Check
```
http://localhost/beyti-api/public/api/health
```

### API Documentation
```
http://localhost/beyti-api/public
```

---

## 📋 Setup Steps

### 1. Ensure Apache is Running
1. Open **XAMPP Control Panel** (`F:\xampp-8.2\xampp-control.exe`)
2. Start **Apache** service
3. Start **MySQL** service

### 2. Enable Apache mod_rewrite (Required for Laravel)

**Check if already enabled:**
Open `F:\xampp-8.2\apache\conf\httpd.conf` and find this line:
```apache
#LoadModule rewrite_module modules/mod_rewrite.so
```

**If it has a `#` at the beginning, remove it:**
```apache
LoadModule rewrite_module modules/mod_rewrite.so
```

**Then restart Apache from XAMPP Control Panel.**

### 3. Create MySQL Database

Open phpMyAdmin: `http://localhost/phpmyadmin`

Run this SQL:
```sql
CREATE DATABASE beyti_visitor CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### 4. Update Database Password

Edit `.env` file:
```env
DB_PASSWORD=your_mysql_password
```

### 5. Run Migrations and Seeders

Open Command Prompt/Terminal in project directory:
```bash
cd F:\xampp-8.2\htdocs\beyti-api

# Run migrations
php artisan migrate

# Seed database
php artisan db:seed
```

### 6. Create First Admin User

In phpMyAdmin or MySQL, run:
```sql
USE beyti_visitor;

INSERT INTO user_roles (email, role, is_active, created_at, updated_at)
VALUES ('admin@example.com', 'admin', 1, NOW(), NOW());
```

---

## 🧪 Testing the API

### Test Health Endpoint
Open browser and visit:
```
http://localhost/beyti-api/public/api/health
```

**Expected Response:**
```json
{
  "status": "ok",
  "timestamp": "2025-01-15T10:30:00+00:00"
}
```

### Test Locations Endpoint (Requires Authentication)

**Using Postman or curl:**
```bash
GET http://localhost/beyti-api/public/api/locations
Authorization: Bearer {your-token-here}
```

---

## 🔧 Common Issues & Solutions

### Issue 1: 404 Not Found
**Problem:** All routes return 404

**Solution:**
1. Check if `mod_rewrite` is enabled in Apache
2. Verify `.htaccess` exists in `public` folder
3. Restart Apache

### Issue 2: 500 Internal Server Error
**Problem:** Server error when accessing API

**Solution:**
1. Check Laravel logs: `storage/logs/laravel.log`
2. Ensure `storage` and `bootstrap/cache` have write permissions
3. Run: `php artisan config:clear`

### Issue 3: Database Connection Failed
**Problem:** Can't connect to database

**Solution:**
1. Verify MySQL is running in XAMPP
2. Check database credentials in `.env`
3. Ensure database `beyti_visitor` exists

### Issue 4: Authorization Header Not Working
**Problem:** Authentication fails even with valid token

**Solution:**
Ensure this line exists in `.htaccess`:
```apache
RewriteCond %{HTTP:Authorization} .
RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]
```

---

## 📁 Directory Structure

```
htdocs/
└── beyti-api/
    ├── app/              # Application code
    ├── config/           # Configuration files
    ├── database/         # Migrations & seeders
    ├── public/           # Document root (Apache serves this)
    │   ├── index.php     # Entry point
    │   └── .htaccess     # URL rewriting rules
    ├── routes/           # API routes
    ├── storage/          # Logs, cache, uploads
    └── .env              # Environment configuration
```

**Important:** Apache should serve from the `public` directory, not the root!

---

## 🚀 API Endpoints Quick Reference

### Public Endpoints
- `GET /api/health` - Health check
- `GET /api/visitor/registration/{token}/validate` - Validate visitor token
- `GET /api/visitor/registration/{token}` - Get visit details
- `POST /api/visitor/registration/{token}/submit` - Submit visitor registration

### Protected Endpoints (Require Authentication)
- `GET /api/auth/user` - Get current user
- `POST /api/auth/logout` - Logout
- `GET /api/locations` - Get locations
- `GET /api/visits` - List visits
- `POST /api/visits` - Create visit
- `GET /api/dashboard/stats` - Dashboard statistics

### Admin Only Endpoints
- `GET /api/settings` - Get system settings
- `PUT /api/settings/azure-ad` - Update Azure AD config
- `PUT /api/settings/smtp` - Update SMTP config
- `GET /api/settings/email-templates` - Get email templates

---

## 🔐 Authentication

This API uses **Sanctum Token-Based Authentication**.

### Getting a Token

1. **For Testing:** You'll need to implement Azure AD authentication or create a test endpoint
2. **For Production:** Use Azure AD SSO flow

### Using the Token

Include in request headers:
```
Authorization: Bearer {your-token-here}
```

---

## 📊 Database Tables

After migration, you'll have these tables:
- `user_roles` - User roles and permissions
- `locations` - Office locations (seeded with 3 locations)
- `visits` - Visit requests
- `visitors` - Visitor details with ID images
- `visit_status_history` - Audit trail
- `settings` - System configuration (seeded)
- `email_templates` - Email templates (9 templates seeded)
- `personal_access_tokens` - API tokens

---

## 🔄 Quick Start Checklist

- [ ] Apache running in XAMPP
- [ ] MySQL running in XAMPP
- [ ] `mod_rewrite` enabled in Apache
- [ ] Database `beyti_visitor` created
- [ ] Migrations run (`php artisan migrate`)
- [ ] Database seeded (`php artisan db:seed`)
- [ ] Admin user created
- [ ] Tested health endpoint: `http://localhost/beyti-api/public/api/health`

---

## 📞 Next Steps

1. **Test the health endpoint** to verify setup
2. **Create admin user** in database
3. **Configure Azure AD** (optional for now)
4. **Set up SMTP** for email notifications
5. **Connect Angular frontend** to this API

---

## 🛠️ Useful Commands

```bash
# Clear all caches
php artisan optimize:clear

# Clear specific caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear

# View routes
php artisan route:list

# Run migrations
php artisan migrate

# Rollback migrations
php artisan migrate:rollback

# Fresh migration (drops all tables and re-runs)
php artisan migrate:fresh --seed

# Create storage link
php artisan storage:link
```

---

**Your API is now ready! 🎉**

Access it at: **http://localhost/beyti-api/public/api**
